﻿using Curse.Friends.Configuration;
using System;
using System.Xml.Serialization;

namespace Curse.Friends.WorkerService.Configuration
{
    [XmlType("PartnerServer")]
    public class PartnerServerConfiguration
    {
        public static PartnerServerConfiguration Instance { get; }

        static PartnerServerConfiguration()
        {
            Instance = ConfigurationHelper.LoadConfiguration<PartnerServerConfiguration>(FriendsServiceConfiguration.Mode, "PartnerServer");
        }

        [XmlElement]
        public Guid GroupID { get; set; }

        [XmlElement]
        public int StaffRoleID { get; set; }

        [XmlElement("Language")]
        public PartnerServerLanguage[] Languages { get; set; }
    }

    public class PartnerServerLanguage
    {
        [XmlElement]
        public string LanguageName { get; set; }

        [XmlElement]
        public string LanguageCode { get; set; }

        [XmlElement]
        public int GroupRoleID { get; set; }

        [XmlElement]
        public bool IsDefault { get; set; }
    }
}
