﻿using Curse.CloudServices.Jobs;
using Curse.Friends.Data;
using Curse.Logging;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Curse.Extensions;

namespace Curse.Friends.WorkerService.Jobs
{
    class PruneExpiredServerInvites : BaseJob
    {
        public override JobScheduleMode ScheduleMode
        {
            get
            {
                return JobScheduleMode.Interval;
            }
        }

        public override int RunFrequencyMinutes
        {
            get
            {
                return 10; 
            }
        }

        public override bool OnlyDefaultRegion
        {
            get
            {
                return true; 
            }
        }

        public override void Run()
        {
            Logger.Info("Running PruneExpiredServerInvites Job.");

            try
            {
                // get everything that expired more than 2 weeks ago. 
                var twoWeeksAgo = DateTime.UtcNow.AddDays(-14);                
                int recordsDeleted = GroupInvitation.DeleteExpiredInvitations(twoWeeksAgo);
                Logger.Info(string.Format("Pruned {0} expired server invite codes", recordsDeleted));
            }
            catch (Exception ex)
            {
                Logger.Error(ex, "Unhandled exception running PruneExpiredServerInvites Job.");
            }        
        }   
    }
}
