﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Curse.Friends.Data;

namespace Curse.Friends.WorkerService.Presence
{
    public class BroadcastingActivity
    {
        public bool IsBroadcasting { get; set; }

        public int BroadcastingGameID { get; set; }

        public bool HasChanged(bool isBroadcasting, int broadcastingGameID)
        {
            return IsBroadcasting != isBroadcasting ||
                BroadcastingGameID != broadcastingGameID;
        }

        public static BroadcastingActivity Create(IOrderedEnumerable<ClientEndpoint> allEndpoints)
        {
            var castingEndpoint = allEndpoints.FirstOrDefault(p => p.IsBroadcasting);
            if (castingEndpoint != null)
            {
                return new BroadcastingActivity
                {
                    IsBroadcasting = true,
                    BroadcastingGameID = castingEndpoint.CurrentlyBroadcastingGameID
                };
            }

            return new BroadcastingActivity
            {
                IsBroadcasting = false,
                BroadcastingGameID = 0
            };
        }
    }
}
