﻿using System;
using System.Linq;
using Curse.Friends.Data;

namespace Curse.Friends.WorkerService.Presence
{
    public class PlayingActivity
    {
        public int CurrentGameID { get; set; }

        public int GameState { get; set; }

        public string GameStatusMessage { get; set; }

        public DateTime GameTimestamp { get; set; }

        public bool HasChanged(int gameID, int gameState, string gameStatusMessage, DateTime gameTime)
        {
            return CurrentGameID != gameID ||
                GameState != gameState ||
                GameStatusMessage != gameStatusMessage ||
                (CurrentGameID > 0 && GameTimestamp != gameTime);
        }

        public static PlayingActivity Create(IOrderedEnumerable<ClientEndpoint> allEndpoints)
        {
            var playingEndpoint = allEndpoints.FirstOrDefault(p => p.CurrentlyPlayingGameID > 0);
            if (playingEndpoint != null)
            {
                return new PlayingActivity
                {
                    CurrentGameID = playingEndpoint.CurrentlyPlayingGameID,
                    GameState = playingEndpoint.CurrentlyPlayingGameState,
                    GameStatusMessage = playingEndpoint.CurrentlyPlayingGameStatusMessage,
                    GameTimestamp = playingEndpoint.CurrentlyPlayingGameTimestamp
                };
            }

            return new PlayingActivity
            {
                CurrentGameID = 0,
                GameState = 0,
                GameStatusMessage = string.Empty,
                GameTimestamp = DateTime.UtcNow
            };
        }
    }
}
