﻿using Curse.Friends.Data;
using Curse.Friends.Enums;
using System;
using System.Collections.Generic;
using System.Linq;

namespace Curse.Friends.WorkerService.Presence
{
    public class UserCapability
    {
        private static readonly ClientCapability AllCapabilities;

        static UserCapability()
        {
            var allCapabilities = Enum.GetValues(typeof(ClientCapability)).Cast<ClientCapability>();
            foreach (var capability in allCapabilities)
            {
                if (capability != ClientCapability.All)
                {
                    AllCapabilities = AllCapabilities | capability;
                }

            }
        }

        public ClientCapability Capability { get; }

        private UserCapability(ClientCapability capability)
        {
            Capability = capability;
        }

        public static UserCapability Create(IReadOnlyCollection<ClientEndpoint> presenceEndpoints)
        {
            if (!presenceEndpoints.Any())
            {
                return new UserCapability(ClientCapability.Unknown);
            }

            var capability = ClientCapability.Unknown;

            // Whispering
            if (presenceEndpoints.Any(p => p.SupportsWhispers))
            {
                capability = capability | ClientCapability.Whispers;
            }

            // Audio Calls
            if (presenceEndpoints.Any(p => p.SupportsAudioCalls))
            {
                capability = capability | ClientCapability.AudioCalls;
            }

            // Video Calls
            if (presenceEndpoints.Any(p => p.SupportsVideoCalls))
            {
                capability = capability | ClientCapability.VideoCalls;
            }

            // Groups
            if (presenceEndpoints.Any(p => p.SupportsGroups))
            {
                capability = capability | ClientCapability.Groups;
            }

            // Servers
            if (presenceEndpoints.Any(p => p.SupportsServers))
            {
                capability = capability | ClientCapability.Servers;
            }

            // File Sharing
            if (presenceEndpoints.Any(p => p.SupportsFileSharing))
            {
                capability = capability | ClientCapability.FileSharing;
            }

            // Image Sharing
            if (presenceEndpoints.Any(p => p.SupportsImageSharing))
            {
                capability = capability | ClientCapability.ImageSharing;
            }


            if (capability == AllCapabilities)
            {
                capability = ClientCapability.All;
            }

            return new UserCapability(capability);

        }
    }
}
