﻿
using Curse.Friends.Data;
using System.Linq;

namespace Curse.Friends.WorkerService.Presence
{
    public class WatchingActivity
    {
        public WatchingActivity(string channelID)
        {
            ChannelID = channelID;
        }

        public string ChannelID { get; set; }

        public bool HasChanged(string channelID)
        {
            return channelID != ChannelID;
        }

        public static WatchingActivity Create(IOrderedEnumerable<ClientEndpoint> allEndpoints)
        {
            var watchingEndpoint = allEndpoints.FirstOrDefault(p => !string.IsNullOrEmpty(p.CurrentlyWatchingChannelID));
            return new WatchingActivity(watchingEndpoint?.CurrentlyWatchingChannelID ?? string.Empty);
        }
    }
}
