﻿using System;
using System.ServiceModel;
using System.ServiceModel.Channels;
using Curse.CloudServices.Client;
using Curse.CloudServices.Models;
using Curse.Friends.Client.FriendsService;

namespace Curse.Friends.Client
{
    public class FriendsWebServiceClient : BaseServiceClient<FriendsWebServiceClient, IFriendsService, FriendsServiceClient>
    {
        private static string _secureServiceUrl;
        private static string _insecureServiceUrl;
        private static bool _isInitialized = false;

        public static void Initalize(string secureServiceUrl, string insecureServiceUrl, Func<int> getUserID, Func<string> getAuthToken, Func<string, bool> renewToken)
        {
            _secureServiceUrl = secureServiceUrl;
            _insecureServiceUrl = insecureServiceUrl;
            _getUserID = getUserID;
            _getAuthToken = getAuthToken;
            _renewToken = renewToken;
            _isInitialized = true;
        }

        private static Func<int> _getUserID;
        private static Func<string> _getAuthToken;
        private static Func<string, bool> _renewToken; 

        protected override bool RenewToken()
        {
            return _renewToken(CurrentToken);
        }

        protected override FriendsServiceClient CreateClient()
        {
            if (!_isInitialized)
            {
                throw new InvalidOperationException("You must initialize the client before using it!");
            }

            CurrentToken = _getAuthToken();

            if (string.IsNullOrEmpty(CurrentToken))
            {
                throw new InvalidOperationException("Unable to create a friends service client. Auth token is null or empty.");
            }

            var url = ServiceClientConfiguration.SslEnabled ? _secureServiceUrl : _insecureServiceUrl;

            Logger.Info("Creating new WCF client for endpoint at: " + url);

            return CreateFriendsClient(_getUserID(), _getAuthToken(), url);            
        }

        private static FriendsServiceClient CreateFriendsClient(int userID, string token, string uri, string apiKey = null)
        {
            // Set the authentication context
            AuthenticationToken.Initialize(userID, token, apiKey);

            CustomBinding binding;
            // The binding configuration
            if (uri.ToLowerInvariant().StartsWith("https://"))
            {
                binding = BindingHelper.GetBinaryBinding(true);
            }
            else
            {
                binding = BindingHelper.GetBinaryBinding(false);
            }

            // Create the client            
            var client = new FriendsServiceClient(binding, new EndpointAddress(uri));

            // Add the behaviour to send the credentials with each request
            client.ChannelFactory.Endpoint.Behaviors.Add(new AuthTokenExtension());

            return client;
        }
    }
}
