﻿using System;
using System.Net;
using System.ServiceModel;
using System.ServiceModel.Channels;
using System.Text;
using System.Xml;

namespace Curse.Friends.Client
{
    class WcfClientHelper
    {
        private static XmlDictionaryReaderQuotas GetDefaultReaderQuotas()
        {
            var readerQuotas = new XmlDictionaryReaderQuotas();
            readerQuotas.MaxArrayLength = 16384;
            readerQuotas.MaxBytesPerRead = 4096;
            readerQuotas.MaxNameTableCharCount = 16384;
            readerQuotas.MaxDepth = 64;
            readerQuotas.MaxStringContentLength = 640000;
            return readerQuotas;
        }

        public static BasicHttpBinding GetDefaultBasicHttpBinding()
        {
            // Reader quotas
            var readerQuotas = GetDefaultReaderQuotas();

            // Basic Http Binding
            var binding = new BasicHttpBinding(BasicHttpSecurityMode.None);
            binding.AllowCookies = false;
            binding.CloseTimeout = TimeSpan.FromSeconds(10);
            binding.OpenTimeout = TimeSpan.FromSeconds(10);
            binding.ReceiveTimeout = TimeSpan.FromSeconds(30);
            binding.SendTimeout = TimeSpan.FromMinutes(5);
            binding.UseDefaultWebProxy = true;
            binding.BypassProxyOnLocal = false;
            binding.HostNameComparisonMode = HostNameComparisonMode.StrongWildcard;
            binding.MaxBufferPoolSize = 524288;
            binding.MaxBufferSize = 6553600;
            binding.MaxReceivedMessageSize = Int32.MaxValue;
            binding.MessageEncoding = WSMessageEncoding.Text;
            binding.TextEncoding = Encoding.UTF8;
            binding.TransferMode = TransferMode.StreamedRequest;
            binding.ReaderQuotas = readerQuotas;

            return binding;
        }        
       
    }
}
