﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Data;
using Curse.FriendsService.Tester.UI.Notifications;

namespace Curse.FriendsService.Tester.UI.Converters
{
    class CallNotificationToStringConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            var notification = value as CallNotification;
            if (notification == null)
            {
                return "Expected a call notification, but was a " + value.GetType().Name;
            }

            var sb = new StringBuilder("Received Voice Invite ");
            if (notification.GroupID.HasValue)
            {
                sb.Append("for Group ").Append(string.Format("{0} ({1}) ", notification.GroupName, notification.GroupID));
            }
            sb.Append("from ").Append(string.Format("{0} ({1}).", notification.SenderName, notification.SenderID));

            return sb.ToString();
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            return null;
        }
    }
}
