﻿using System;
using System.Globalization;
using System.Windows.Data;
using System.Windows.Media;
using Curse.Friends.Enums;
using Curse.FriendsService.Tester.UI.ViewModels;

namespace Curse.FriendsService.Tester.UI.Converters
{
    class FriendToBrushConverter : IValueConverter
    {
        private readonly StatusToBrushConverter _statusToBrushConverter;

        public FriendToBrushConverter()
        {
            _statusToBrushConverter = new StatusToBrushConverter();
        }

        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            var friend = value as FriendViewModel;
            if (friend != null && friend.FriendshipStatus==FriendshipStatus.Confirmed)
            {
                return _statusToBrushConverter.Convert(friend.ConnectionStatus, targetType, parameter, culture);
            }
            return new SolidColorBrush(Colors.DimGray);
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            return null;
        }
    }
}
