﻿using System;
using System.Globalization;
using System.Windows.Data;
using Curse.FriendsService.Tester.UI.ViewModels;

namespace Curse.FriendsService.Tester.UI.Converters
{
    class FriendToTextConverter : IValueConverter
    {
        private readonly UserToTextConverter _userToTextConverter;

        public FriendToTextConverter()
        {
            _userToTextConverter = new UserToTextConverter();
        }

        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            var friend = value as FriendViewModel;
            return friend == null
                ? null
                : DecorateWithFavorite(DecorateWithNickname((string) _userToTextConverter.Convert(value, targetType, parameter, culture), friend.Nickname), friend.Favorite);

        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            return null;
        }

        

        private string DecorateWithNickname(string text, string nickname)
        {
            return nickname == null ? text : string.Format("{0} - {1}", nickname, text);
        }

        private string DecorateWithFavorite(string text, bool favorite)
        {
            return favorite ? string.Format("*{0}*", text) : text;
        }
    }
}
