﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Data;
using Curse.FriendsService.Tester.UI.ViewModels;

namespace Curse.FriendsService.Tester.UI.Converters
{
    class GroupToTextConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            var group = value as GroupViewModel;
            if (group == null)
            {
                return "Unknown";
            }

            return DecorateWithFavorite(DecorateWithMuted(GetBaseText(group.GroupID, group.Title), group.Muted),
                group.Favorite);
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            return null;
        }

        private string GetBaseText(Guid groupID, string title)
        {
            return string.Format("{0} ({1})", title, groupID);
        }

        private string DecorateWithMuted(string input, bool isMuted)
        {
            return isMuted ? input + " - muted" : input;
        }

        private string DecorateWithFavorite(string input, bool isFavorite)
        {
            return isFavorite ? string.Format("*{0}*", input) : input;
        }
    }
}
