﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Data;
using System.Windows.Media;
using Curse.Friends.Enums;
using Curse.FriendsService.Tester.UI.ViewModels;

namespace Curse.FriendsService.Tester.UI.Converters
{
    class StatusToBrushConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            Color foreground = Colors.DimGray;

            if (value is UserConnectionStatus)
            {
                switch ((UserConnectionStatus)value)
                {
                    case UserConnectionStatus.Online:
                        foreground = Colors.Green;
                        break;
                    case UserConnectionStatus.Invisible:
                        foreground = Colors.DodgerBlue;
                        break;
                    case UserConnectionStatus.Away:
                    case UserConnectionStatus.Idle:
                        foreground = Colors.Goldenrod;
                        break;
                    case UserConnectionStatus.DoNotDisturb:
                        foreground = Colors.DarkRed;
                        break;
                    default:
                        foreground = Colors.DimGray;
                        break;
                }
            }

            return new SolidColorBrush(foreground);
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            return null;
        }
    }
}
