﻿using System;
using System.Collections.Generic;

namespace Curse.FriendsService.Tester.UI.Messaging
{
    internal class GlobalMessenger : IMessenger
    {
        private static readonly GlobalMessenger SingletonInstance = new GlobalMessenger(null);
        public static GlobalMessenger Instance { get { return SingletonInstance; } }

        /// <summary>
        /// Private to prevent construction outside of this class.
        /// </summary>
        private GlobalMessenger(IMessenger parent)
        {
            _parent = parent;
        }

        private readonly List<Delegate> _actions = new List<Delegate>();

        private readonly IMessenger _parent;

        public void Register<T>(Action<T> callback) where T : IViewModelMessage
        {
            _actions.Add(callback);
        }

        public void ClearCallbacks()
        {
            _actions.Clear();
        }

        public void Raise<T>(T args) where T : IViewModelMessage
        {
            foreach (var action in _actions.ToArray())
            {
                var action1 = action as Action<T>;
                if (action1 != null)
                {
                    action1(args);
                }
            }

            // Bubble up message as well
            if (_parent != null)
            {
                _parent.Raise(args);
            }
        }

        public IMessenger GetScopedMessenger()
        {
            return new GlobalMessenger(this);
        }
    }
}
