﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Curse.FriendsService.Tester.UI.Messaging
{
    interface IMessenger
    {
        // Registers a callback for the given domain event
        void Register<T>(Action<T> callback) where T : IViewModelMessage;

        // Clears callbacks passed to Register on the current thread
        void ClearCallbacks();

        // Raises the given domain event
        void Raise<T>(T args) where T : IViewModelMessage;
    }
}
