﻿using Curse.FriendsService.Tester.Actions;
using Curse.FriendsService.Tester.UI.Messaging;

namespace Curse.FriendsService.Tester.UI.Options
{
    class AddFriendCommand : BaseCommandOption
    {
        public AddFriendCommand(IMessenger messenger) : base(messenger)
        {
        }

        public override string Name
        {
            get { return "Add Friend"; }
        }

        public override void Execute(TestClient client)
        {
            string message;
            RequestFriendResponseType responseType;
            if (client.Execute(new RequestFriend(UserID, KnownIdentity){InvitationMessage = "Friend request via tester UI."}, out responseType, out message))
            {
                SendNotificationMessage("Requested friendship with {0} ({1}).", KnownIdentity, UserID);
            }
            else
            {
                SendNotificationMessage(message);
            }
        }

        public int UserID { get; set; }
        public string KnownIdentity { get; set; }
    }
}
