﻿using System.Collections.ObjectModel;
using System.Linq;
using System.Windows.Input;
using Curse.FriendsService.Tester.Actions;
using Curse.FriendsService.Tester.UI.Messaging;
using Curse.FriendsService.Tester.UI.ViewModels;

namespace Curse.FriendsService.Tester.UI.Options
{
    class AddGroupMemberCommand : BaseCommandOption
    {
        public AddGroupMemberCommand(IMessenger messenger, GroupsList groupsList, FriendsList friendsList) : base(messenger)
        {
            Groups = groupsList.Groups;
            Group = Groups.FirstOrDefault();

            Friends = friendsList.Friends;

            MembersToAdd = new DispatchedObservableCollection<FriendViewModel>();

            AddMemberToAddCommand = new RelayCommand<FriendViewModel>(AddMemberToAdd);
            RemoveMemberToAddCommand = new RelayCommand<FriendViewModel>(RemoveMemberToAdd);
        }

        public override string Name
        {
            get { return "Add Group Member"; }
        }

        public override void Execute(TestClient client)
        {
            string errorMessage;
            if (client.Execute(new AddGroupMember(Group.GroupID, MembersToAdd.Select(m=>m.UserID).ToArray()), out errorMessage))
            {
                SendNotificationMessage("Group {0}: Added members to Group {1}", Group.Title, Group.GroupID);
            }
            else
            {
                SendNotificationMessage("Group {0}: {1}", Group.Title, errorMessage);
            }
        }

        public ObservableCollection<GroupViewModel> Groups { get; private set; }
        public GroupViewModel Group { get; set; }

        public ObservableCollection<FriendViewModel> Friends { get; private set; }

        public ObservableCollection<FriendViewModel> MembersToAdd { get; private set; }

        public ICommand AddMemberToAddCommand { get; private set; }
        private void AddMemberToAdd(FriendViewModel friend)
        {
            if (friend == null)
            {
                return;
            }

            MembersToAdd.Add(friend);
        }

        public ICommand RemoveMemberToAddCommand { get; private set; }
        private void RemoveMemberToAdd(FriendViewModel friend)
        {
            MembersToAdd.Remove(friend);
        }
    }
}
