﻿using Curse.FriendsService.Tester.UI.Messaging;
using Curse.FriendsService.Tester.UI.ViewModels;

namespace Curse.FriendsService.Tester.UI.Options
{
    abstract class BaseCommandOption : BaseViewModel
    {
        public abstract string Name { get; }
        public abstract void Execute(TestClient client);

        private readonly IMessenger _messenger;

        protected BaseCommandOption(IMessenger messenger)
        {
            _messenger = messenger;
        }

        protected void SendNotificationMessage(string message, params object[] args)
        {
            _messenger.Raise(new NotificationMessage
            {
                Message = string.Format(message, args)
            });
        }
    }
}
