﻿using Curse.FriendsService.Tester.Actions;
using Curse.FriendsService.Tester.UI.Messaging;

namespace Curse.FriendsService.Tester.UI.Options
{
    class ChangeGameStatusCommand : BaseCommandOption
    {
        public ChangeGameStatusCommand(IMessenger messenger) : base(messenger)
        {
        }

        public override string Name
        {
            get { return "Change Game Status"; }
        }

        public override void Execute(TestClient client)
        {
            string errorMessage;
            if (client.Execute(new ChangeGameStatus(GameID) {StatusMessage = GameStatus, IsRunning = GameID != 0}, out errorMessage))
            {
                SendNotificationMessage("Updated game status.");
            }
            else
            {
                SendNotificationMessage("Failed to update game status. {0}", errorMessage);
            }
        }

        public int GameID { get; set; }
        public string GameStatus { get; set; }
    }
}
