﻿using System.Collections.ObjectModel;
using System.Linq;
using Curse.Friends.Enums;
using Curse.FriendsService.Tester.Actions;
using Curse.FriendsService.Tester.UI.Messaging;
using Curse.FriendsService.Tester.UI.ViewModels;

namespace Curse.FriendsService.Tester.UI.Options
{
    class ChangeGroupMemberRoleCommand : BaseCommandOption
    {
        public ChangeGroupMemberRoleCommand(IMessenger messenger, GroupsList groupsList) : base(messenger)
        {
            Groups = groupsList.Groups;
            Group = Groups.FirstOrDefault();
        }

        public override string Name
        {
            get { return "Change Member Role"; }
        }

        public override void Execute(TestClient client)
        {
            //string errorMessage;
            //if (client.Execute(new ChangeGroupMemberRole(Group.GroupID, GroupMember.UserID, Role), out errorMessage))
            //{
            //    SendNotificationMessage("Changed {0} ({1}) to {2}.", GroupMember.Username, GroupMember.UserID, Role);
            //}
            //else
            //{
            //    SendNotificationMessage(errorMessage);
            //}
            SendNotificationMessage("Not Implemented after refactor!");
        }

        public ObservableCollection<GroupViewModel> Groups { get; private set; }

        private GroupViewModel _group;
        public GroupViewModel Group
        {
            get
            {
                return _group;
            }
            set
            {
                if (_group != value)
                {
                    _group = value;
                    OnPropertyChanged();

                    if (_group != null)
                    {
                        _group.RefreshGroupDetails();
                        GroupMembers = _group.Members;
                    }
                }
            }
        }

        private ObservableCollection<GroupMemberViewModel> _groupMembers;
        public ObservableCollection<GroupMemberViewModel> GroupMembers
        {
            get
            {
                return _groupMembers;
            }
            private set
            {
                if (_groupMembers != value)
                {
                    _groupMembers = value;
                    OnPropertyChanged();

                    if (_groupMembers != null)
                    {
                        GroupMember = _groupMembers.FirstOrDefault();
                    }
                }
            }
        }

        private GroupMemberViewModel _groupMember;
        public GroupMemberViewModel GroupMember
        {
            get
            {
                return _groupMember;
            }
            set
            {
                if (_groupMember != value)
                {
                    _groupMember = value;
                    OnPropertyChanged();
                }
            }
        }
    }
}
