﻿using System.Collections.ObjectModel;
using System.Linq;
using Curse.Friends.Enums;
using Curse.FriendsService.Tester.Actions;
using Curse.FriendsService.Tester.UI.Messaging;
using Curse.FriendsService.Tester.UI.ViewModels;

namespace Curse.FriendsService.Tester.UI.Options
{
    class ChangeGroupNotificationPreferenceCommand : BaseCommandOption
    {
        public ChangeGroupNotificationPreferenceCommand(IMessenger messenger, GroupsList groupsList) : base(messenger)
        {
            Groups = groupsList.Groups;
            Group = Groups.FirstOrDefault();
        }

        public override string Name
        {
            get { return "Change Group Notification"; }
        }

        public override void Execute(TestClient client)
        {
            var filterSet = string.IsNullOrWhiteSpace(Filter) ? null : Filter.Split(';').Select(s => s.Trim()).ToArray();
            var preference = Mute
                ? filterSet==null
                    ? NotificationPreference.Disabled
                    : NotificationPreference.Filtered
                : NotificationPreference.Enabled;

            string errorMessage;
            if (client.Execute(new ChangeGroupNotificationPreferences(Group.GroupID, preference) {Filters = filterSet}, out errorMessage))
            {
                SendNotificationMessage("Group {0}: Changed {1} Notification Preference to {2}", Group.Title, Group.GroupID, preference);
            }
            else
            {
                SendNotificationMessage("Group {0}: {1}", Group.Title, errorMessage);
            }
        }

        public ObservableCollection<GroupViewModel> Groups { get; private set; }
        public GroupViewModel Group { get; set; }
        public bool Mute { get; set; }
        public string Filter { get; set; }
    }
}
