﻿using Curse.Friends.Enums;
using Curse.FriendsService.Tester.Actions;
using Curse.FriendsService.Tester.UI.Messaging;

namespace Curse.FriendsService.Tester.UI.Options
{
    class ChangeStatusCommand : BaseCommandOption
    {
        public ChangeStatusCommand(IMessenger messenger) : base(messenger)
        {
        }

        public override string Name
        {
            get { return "Change Status"; }
        }

        public override void Execute(TestClient client)
        {
            string error;
            if (!client.Execute(new ChangeStatus(NewStatus) {StatusMessage = StatusMessage}, out error))
            {
                SendNotificationMessage(error);
            }
        }

        public string StatusMessage { get; set; }
        public UserConnectionStatus NewStatus { get; set; }
    }
}
