﻿using Curse.FriendsService.Tester.Actions;
using Curse.FriendsService.Tester.UI.Messaging;

namespace Curse.FriendsService.Tester.UI.Options
{
    class ClaimGroupInviteCommand : BaseCommandOption
    {
        public ClaimGroupInviteCommand(IMessenger messenger) : base(messenger)
        {
        }

        public override string Name
        {
            get { return "Claim Group Invite"; }
        }

        public override void Execute(TestClient client)
        {
            string error;
            if (client.Execute(new ClaimGroupInvite(InviteCode), out error))
            {
                SendNotificationMessage("Claimed Group Invite {0}.", InviteCode);
            }
            else
            {
                SendNotificationMessage(error);
            }
        }

        public string InviteCode { get; set; }
    }
}
