﻿using System;
using System.Collections.ObjectModel;
using System.Linq;
using Curse.FriendsService.Tester.Actions;
using Curse.FriendsService.Tester.UI.Messaging;
using Curse.FriendsService.Tester.UI.ViewModels;

namespace Curse.FriendsService.Tester.UI.Options
{
    class CreateGroupInviteCommand : BaseCommandOption
    {
        public CreateGroupInviteCommand(IMessenger messenger, GroupsList groupsList) : base(messenger)
        {
            Groups = groupsList.Groups;
            Group = Groups.FirstOrDefault();
        }

        public override string Name
        {
            get { return "Create Group Invite"; }
        }

        public override void Execute(TestClient client)
        {
            string error;
            string inviteCode;
            if (client.Execute(new CreateGroupInvite(Group.GroupID)
            {
                AutoRemoveGuests = AutoRemoveGuests,
                LifeTime = LifeTimeHours <= 0 ? (TimeSpan?) null : TimeSpan.FromHours(LifeTimeHours)
            }, out inviteCode, out error))
            {
                SendNotificationMessage(string.Format("Invitation {0} created for Group {1} ({2})", inviteCode, Group.Title, Group.GroupID));
            }
            else
            {
                SendNotificationMessage("Group {0}: {1}", Group.Title, error);

            }
        }

        public ObservableCollection<GroupViewModel> Groups { get; private set; }
        public GroupViewModel Group { get; set; }
        public bool AutoRemoveGuests { get; set; }
        public int LifeTimeHours { get; set; }
    }
}
