﻿using System.Collections.ObjectModel;
using System.Linq;
using Curse.FriendsService.Tester.Actions;
using Curse.FriendsService.Tester.UI.Messaging;
using Curse.FriendsService.Tester.UI.ViewModels;

namespace Curse.FriendsService.Tester.UI.Options
{
    class DeleteGroupCommand : BaseCommandOption
    {
        public override string Name
        {
            get { return "Delete Group"; }
        }

        public DeleteGroupCommand(IMessenger messenger, GroupsList groupsList) : base(messenger)
        {
            Groups = groupsList.Groups;
            Group = Groups.FirstOrDefault();
        }

        public ObservableCollection<GroupViewModel> Groups { get; private set; }
        public GroupViewModel Group { get; set; }

        public override void Execute(TestClient client)
        {
            string error;
            if (client.Execute(new DeleteGroup(Group.GroupID), out error))
            {
                SendNotificationMessage("Group {0}: Successfully deleted {1}.", Group.Title, Group.GroupID);
            }
            else
            {
                SendNotificationMessage("Group {0}: {1}", Group.Title, error);
            }
        }
    }
}
