﻿using System.Collections.ObjectModel;
using System.Linq;
using Curse.FriendsService.Tester.Actions;
using Curse.FriendsService.Tester.UI.Messaging;
using Curse.FriendsService.Tester.UI.ViewModels;

namespace Curse.FriendsService.Tester.UI.Options
{
    class DeleteGroupInviteCommand : BaseCommandOption
    {
        public DeleteGroupInviteCommand(IMessenger messenger, GroupsList groupsList) : base(messenger)
        {
            Groups = groupsList.Groups;
            Group = Groups.FirstOrDefault();
        }

        public override string Name
        {
            get { return "Delete Group Invite"; }
        }

        public override void Execute(TestClient client)
        {
            if (GroupInvite == null)
            {
                SendNotificationMessage("No invitation is selected to delete.");
                return;
            }

            string error;
            if (client.Execute(new DeleteGroupInvite(GroupInvite.Invite), out error))
            {
                SendNotificationMessage("Group {0} ({1}): Deleted invite {2}", Group.Title, Group.GroupID, GroupInvite.Invite);
            }
            else
            {
                SendNotificationMessage("Group {0} ({1}): {2}", Group.Title, Group.GroupID, error);
            }
        }

        public ObservableCollection<GroupViewModel> Groups { get; private set; }

        private GroupViewModel _group;

        public GroupViewModel Group
        {
            get
            {
                return _group;
            }
            set
            {
                if (_group != value)
                {
                    _group = value;
                    OnPropertyChanged();

                    GroupInvites = _group != null ? _group.AllGroupInvites : new ObservableCollection<GroupInviteViewModel>();
                }
            }
        }

        private ObservableCollection<GroupInviteViewModel> _groupInvites;
        public ObservableCollection<GroupInviteViewModel> GroupInvites
        {
            get
            {
                return _groupInvites;
            }
            private set
            {
                if (_groupInvites != value)
                {
                    _groupInvites = value;
                    OnPropertyChanged();

                    GroupInvite = _groupInvites.FirstOrDefault();
                }
            }
        }

        private GroupInviteViewModel _groupInvite;
        public GroupInviteViewModel GroupInvite
        {
            get
            {
                return _groupInvite;
            }
            set
            {
                if (_groupInvite != value)
                {
                    _groupInvite = value;
                    OnPropertyChanged();
                }
            }
        }

        public bool RemoveGuests { get; set; }
    }
}
