﻿using System.Collections.ObjectModel;
using System.Linq;
using Curse.FriendsService.Tester.Actions;
using Curse.FriendsService.Tester.UI.Messaging;
using Curse.FriendsService.Tester.UI.ViewModels;

namespace Curse.FriendsService.Tester.UI.Options
{
    class LeaveGroupCommand : BaseCommandOption
    {
        public LeaveGroupCommand(IMessenger messenger, GroupsList groupsList) : base(messenger)
        {
            Groups = groupsList.Groups;
            Group = Groups.FirstOrDefault();
        }

        public override string Name
        {
            get { return "Leave Group"; }
        }

        public override void Execute(TestClient client)
        {
            string error;
            if (client.Execute(new LeaveGroup(Group.GroupID), out error))
            {
                SendNotificationMessage("Group {0}: Left Group {1}.", Group.Title, Group.GroupID);
            }
            else
            {
                SendNotificationMessage("Group {0}: {1}", Group.Title, error);
            }
        }

        public ObservableCollection<GroupViewModel> Groups { get; private set; }
        public GroupViewModel Group { get; set; }
    }
}
