﻿using System.Collections.ObjectModel;
using System.Linq;
using Curse.FriendsService.Tester.Actions;
using Curse.FriendsService.Tester.UI.Messaging;
using Curse.FriendsService.Tester.UI.ViewModels;

namespace Curse.FriendsService.Tester.UI.Options
{
    class MessageFriendCommand : BaseCommandOption
    {
        public MessageFriendCommand(IMessenger messenger, FriendsList friendsList) :base(messenger)
        {
            Friends = friendsList.Friends;
            Friend = Friends.FirstOrDefault();
        }

        public ObservableCollection<FriendViewModel> Friends { get; private set; } 

        public FriendViewModel Friend { get; set; }
        public string Message { get; set; }

        public override string Name
        {
            get { return "Message Friend"; }
        }

        public override void Execute(TestClient client)
        {
            string error;
            client.Execute(new MessageFriend(Friend.UserID, Message), out error);
        }
    }
}
