﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text.RegularExpressions;
using Curse.FriendsService.Tester.Actions;
using Curse.FriendsService.Tester.UI.Messaging;
using Curse.FriendsService.Tester.UI.ViewModels;
using Curse.FriendsService.Tester.Utilities;

namespace Curse.FriendsService.Tester.UI.Options
{
    internal class MessageGroupCommand : BaseCommandOption
    {
        private readonly ObservableCollection<FriendViewModel> _friends;
 
        public MessageGroupCommand(IMessenger messenger, GroupsList groupsList, FriendsList friendsList) : base(messenger)
        {
            Groups = groupsList.Groups;
            Group = Groups.FirstOrDefault();
            _friends = friendsList.Friends;
        }

        public ObservableCollection<GroupViewModel> Groups { get; private set; }

        public GroupViewModel Group { get; set; }
        public string Message { get; set; }

        public override string Name
        {
            get { return "Message Group"; }
        }

        public override void Execute(TestClient client)
        {
            string error;

            client.Execute(new MessageGroup(Group.GroupID, ResolveMentions()), out error);
        }

        private string ResolveMentions()
        {
            if (Group.Members.Count == 0)
            {
                // Force load here
                Group.RefreshGroupDetails();
            }

            var allTerms = Group.Members.Select(m => new {Term = m.Username, UserID = m.UserID, Username = m.Username})
                .Concat(_friends.Where(f => f.Nickname != null && Group.Members.Any(m => m.UserID == f.UserID)).Select(f => new {Term = f.Nickname, UserID = f.UserID, Username = f.Username}));

            var mapping = new Dictionary<string, Tuple<int, string>>();
            // Not using the ToDictionary extension since nicknames are not necessarily unique and can even match usernames
            foreach (var term in allTerms)
            {
                if (mapping.ContainsKey(term.Term))
                {
                    continue;
                }

                mapping.Add(term.Term, new Tuple<int, string>(term.UserID, term.Username));
            }

            return MentionsHelper.ResolveMentionsForSend(Message, mapping);
        } 
    }
}
