﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Windows.Input;
using Curse.Friends.Enums;
using Curse.FriendsService.Tester.Actions;
using Curse.FriendsService.Tester.UI.Messaging;
using Curse.FriendsService.Tester.UI.ViewModels;

namespace Curse.FriendsService.Tester.UI.Options
{
    class NewGroupCommand : BaseCommandOption
    {
        private static readonly GroupViewModel DefaultGroup = new GroupViewModel(null,null,null,null)
        {
            Title = "No parent",
            GroupID = Guid.Empty
        };
        public IEnumerable<GroupViewModel> DefaultGroups { get { return new[] {DefaultGroup}; } }

        public override string Name
        {
            get { return "New Group"; }
        }

        public string Title { get; set; }
        public GroupType Type { get; set; }
        public ObservableCollection<FriendViewModel> AddedMembers { get; private set; }
        public GroupViewModel ParentGroup { get; set; }


        public override void Execute(TestClient client)
        {
            string error;
            Guid groupID;
            if (client.Execute(new CreateGroup(Title, Type)
            {
                ParentGroupID = ParentGroup.GroupID,
                NewMembers = AddedMembers.Select(f => f.UserID).ToArray()
            }, out groupID, out error))
            {
                SendNotificationMessage("Successfully created group {0} ({1})", Title, groupID);
            }
            else
            {
                SendNotificationMessage(error);
            }
        }

        public ObservableCollection<FriendViewModel> Friends { get; private set; }
        public ObservableCollection<GroupViewModel> Groups { get; set; }

        public NewGroupCommand(IMessenger messenger, FriendsList friendsList, GroupsList groupsList) : base(messenger)
        {
            Friends = friendsList.Friends;
            Groups = groupsList.Groups;

            AddedMembers = new ObservableCollection<FriendViewModel>();

            ParentGroup = DefaultGroup;

            AddNewGroupMemberCommand = new RelayCommand<FriendViewModel>(vm =>
            {
                if (vm == null || AddedMembers.Any(m=>m.UserID==vm.UserID))
                {
                    return;
                }
                AddedMembers.Add(vm);
            });

            RemoveNewGroupMemberCommand = new RelayCommand<FriendViewModel>(vm => AddedMembers.Remove(vm));
        }

        public ICommand AddNewGroupMemberCommand { get; private set; }
        public ICommand RemoveNewGroupMemberCommand { get; private set; }
    }
}
