﻿using System.Collections.ObjectModel;
using System.Linq;
using Curse.FriendsService.Tester.Actions;
using Curse.FriendsService.Tester.UI.Messaging;
using Curse.FriendsService.Tester.UI.ViewModels;

namespace Curse.FriendsService.Tester.UI.Options
{
    class RemoveFriendCommand : BaseCommandOption
    {
        public RemoveFriendCommand(IMessenger messenger, FriendsList friendsList) : base(messenger)
        {
            Friends = friendsList.Friends;
            Friend = Friends.FirstOrDefault();
        }

        public override string Name
        {
            get { return "Unfriend"; }
        }

        public override void Execute(TestClient client)
        {
            string error;
            if (client.Execute(new RemoveFriend(Friend.UserID), out error))
            {
                SendNotificationMessage("Successfully Unfriended {0} ({1})", Friend.Username, Friend.UserID);
            }
            else
            {
                SendNotificationMessage("Failed to unfriend {0}. {1}", Friend.Username, error);
            }
        }

        public ObservableCollection<FriendViewModel> Friends { get; private set; }
        public FriendViewModel Friend { get; set; }
    }
}
