﻿using System.Collections.ObjectModel;
using System.Linq;
using Curse.FriendsService.Tester.Actions;
using Curse.FriendsService.Tester.UI.Messaging;
using Curse.FriendsService.Tester.UI.ViewModels;

namespace Curse.FriendsService.Tester.UI.Options
{
    class RenameGroupCommand : BaseCommandOption
    {
        public ObservableCollection<GroupViewModel> Groups { get; private set; }

        public string NewTitle { get; set; }
        public GroupViewModel Group { get; set; }

        public RenameGroupCommand(IMessenger messenger, GroupsList groupsList) : base(messenger)
        {
            Groups = groupsList.Groups;
            Group = Groups.FirstOrDefault();
        }

        public override string Name
        {
            get { return "Rename Group"; }
        }

        public override void Execute(TestClient client)
        {
            var oldTitle = Group.Title;
            string errorMessage;
            if (client.Execute(new ChangeGroupInfo(Group.GroupID) {Title = NewTitle}, out errorMessage))
            {
                SendNotificationMessage(string.Format("Renamed Group {0} to {1}.", oldTitle, NewTitle));
            }
            else
            {
                SendNotificationMessage(string.Format("Could not rename Group {0}. {1}", oldTitle, errorMessage));
            }
        }
    }
}
