﻿using System;
using System.Collections.ObjectModel;
using System.Linq;
using Curse.FriendsService.Tester.Actions;
using Curse.FriendsService.Tester.UI.Messaging;
using Curse.FriendsService.Tester.UI.ViewModels;

namespace Curse.FriendsService.Tester.UI.Options
{
    class SyncOfflineMessagesCommand : BaseCommandOption
    {
        public SyncOfflineMessagesCommand(IMessenger messenger, GroupsList groupsList, FriendsList friendsList) : base(messenger)
        {
            Groups = groupsList.Groups;
            Group = Groups.FirstOrDefault();

            Friends = friendsList.Friends;
            Friend = Friends.FirstOrDefault();
        }

        public override string Name
        {
            get { return "Sync Offline Messages"; }
        }

        public override void Execute(TestClient client)
        {
            string error;
            client.Execute(new SyncOfflineMessages(DateTime.UtcNow - TimeSpan.FromDays(DaysToSync))
            {
                FriendID = SyncFriend ? (int?) Friend.UserID : null,
                GroupID = SyncGroup ? (Guid?) Group.GroupID : null,
            }, out error);
        }

        public int DaysToSync { get; set; }

        public ObservableCollection<GroupViewModel> Groups { get; private set; }
        public GroupViewModel Group { get; set; }

        public ObservableCollection<FriendViewModel> Friends { get; private set; }
        public FriendViewModel Friend { get; set; }

        private bool _syncGroup;
        public bool SyncGroup
        {
            get
            {
                return _syncGroup;
            }
            set
            {
                if (_syncGroup != value)
                {
                    _syncGroup = value;
                    OnPropertyChanged();
                }
            }
        }

        private bool _syncFriend;
        public bool SyncFriend
        {
            get
            {
                return _syncFriend;
            }
            set
            {
                if (_syncFriend != value)
                {
                    _syncFriend = value;
                    OnPropertyChanged();
                }
            }
        }
    }
}
