﻿using System.Collections.ObjectModel;
using System.Linq;
using Curse.FriendsService.Tester.Actions;
using Curse.FriendsService.Tester.UI.Messaging;
using Curse.FriendsService.Tester.UI.ViewModels;

namespace Curse.FriendsService.Tester.UI.Options
{
    class ToggleFavoriteFriendCommand : BaseCommandOption
    {
        public ToggleFavoriteFriendCommand(IMessenger messenger, FriendsList friendsList) : base(messenger)
        {
            Friends = friendsList.Friends;
            Friend = Friends.FirstOrDefault();
        }

        public override string Name
        {
            get { return "Toggle Favorite Friend"; }
        }

        public override void Execute(TestClient client)
        {
            var favoriteString = Favorite ? "favorite" : "not a favorite";
            string error;
            if (client.Execute(new ToggleFavoriteFriend(Friend.UserID, Favorite), out error))
            {
                SendNotificationMessage("Toggled {0} ({1}) to {2}.", Friend.Username, Friend.UserID, favoriteString);
            }
            else
            {
                SendNotificationMessage("Failed to toggle favorite for friend {0}. {1}", Friend.Username, error);
            }
        }

        public bool Favorite { get; set; }
        public ObservableCollection<FriendViewModel> Friends { get; private set; }
        public FriendViewModel Friend { get; set; }
    } 
}
