﻿using System.Collections.ObjectModel;
using System.Linq;
using Curse.FriendsService.Tester.Actions;
using Curse.FriendsService.Tester.UI.Messaging;
using Curse.FriendsService.Tester.UI.ViewModels;

namespace Curse.FriendsService.Tester.UI.Options
{
    class ToggleFavoriteGroupCommand : BaseCommandOption
    {
        public override string Name
        {
            get { return "Toggle Group Favorite"; }
        }

        public ToggleFavoriteGroupCommand(IMessenger messenger, GroupsList groupsList) : base(messenger)
        {
            Groups = groupsList.Groups;
            Group = Groups.FirstOrDefault();
        }

        public ObservableCollection<GroupViewModel> Groups { get; private set; }
        public GroupViewModel Group { get; set; }
        public bool Favorite { get; set; }

        public override void Execute(TestClient client)
        {
            string error;
            if (client.Execute(new ToggleFavoriteGroup(Group.GroupID, Favorite), out error))
            {
                Group.Favorite = Favorite;
                SendNotificationMessage(string.Format("Group {0}: Set {1} to {2}.", Group.Title, Group.GroupID, Favorite ? "favorite." : "not favorite"));
            }
            else
            {
                SendNotificationMessage("Group {0}: {1}", Group.Title, error);
            }
        }
    }
}
