﻿using Curse.FriendsService.Tester.Actions;
using Curse.FriendsService.Tester.UI.Messaging;

namespace Curse.FriendsService.Tester.UI.Options
{
    class UnblockFriendCommand : BaseCommandOption
    {
        public UnblockFriendCommand(IMessenger messenger) : base(messenger)
        {
        }

        public override string Name
        {
            get { return "Unblock Friend"; }
        }

        public override void Execute(TestClient client)
        {
            string error;
            if (client.Execute(new UnblockFriend(FriendID), out error))
            {
                SendNotificationMessage("Unblocked {0}.", FriendID);
            }
            else
            {
                SendNotificationMessage("Failed to unblock {0}. {1}", FriendID, error);
            }
        }

        public int FriendID { get; set; }
    }
}
