﻿using System.Collections.ObjectModel;
using System.Linq;
using Curse.FriendsService.Tester.Actions;
using Curse.FriendsService.Tester.UI.Messaging;
using Curse.FriendsService.Tester.UI.ViewModels;

namespace Curse.FriendsService.Tester.UI.Options
{
    class VoiceCallCommand : BaseCommandOption
    {
        public VoiceCallCommand(IMessenger messenger, GroupsList groupsList, FriendsList friendsList) : base(messenger)
        {
            Groups = groupsList.Groups;
            Group = Groups.FirstOrDefault();

            Friends = friendsList.Friends;
            Friend = Friends.FirstOrDefault();

            CallFriend = true;
        }

        public override string Name
        {
            get { return "Voice Call"; }
        }

        public override void Execute(TestClient client)
        {
            string recipient;
            string error;
            string inviteCode;
            if (CallFriend)
            {
                recipient = string.Format("{0} ({1})", Friend.Username, Friend.UserID);
                if (client.Execute(new CallFriend(Friend.UserID), out inviteCode, out error))
                {
                    SendNotificationMessage("Successfully called {0}.", recipient);
                }
                else
                {
                    SendNotificationMessage("Failed to call {0}. Status={1}.", recipient, error);
                }
            }
            else
            {
                recipient = string.Format("{0} ({1})", Group.Title, Group.GroupID);
                if (client.Execute(new CallGroup(Group.GroupID), out inviteCode, out error))
                {
                    SendNotificationMessage("Successfully called {0}.", recipient);
                }
                else
                {
                    SendNotificationMessage("Failed to call {0}. Status={1}.", recipient, error);
                }
            }
        }

        private bool _callGroup;
        public bool CallGroup
        {
            get { return _callGroup; }
            set
            {
                if (_callGroup != value)
                {
                    _callGroup = value;
                    OnPropertyChanged();
                }
            }
        }

        private bool _callFriend;
        public bool CallFriend
        {
            get { return _callFriend; }
            set
            {
                if (_callFriend != value)
                {
                    _callFriend = value;
                    OnPropertyChanged();
                }
            }
        }

        public ObservableCollection<GroupViewModel> Groups { get; private set; }
        public GroupViewModel Group { get; set; }

        public ObservableCollection<FriendViewModel> Friends { get; private set; }
        public FriendViewModel Friend { get; set; }
    }
}
