﻿using System;
using System.Windows.Input;

namespace Curse.FriendsService.Tester.UI
{
    class RelayCommand : ICommand
    {
        private readonly Action _execute;
        private readonly Func<bool> _canExecute;

        public RelayCommand(Action execute, Func<bool> canExecute = null)
        {
            _execute = execute;
            _canExecute = canExecute ?? (() => true);
        }

        public bool CanExecute(object parameter)
        {
            return _canExecute();
        }

        public void Execute(object parameter)
        {
            _execute();
        }

        public event EventHandler CanExecuteChanged
        {
            add { CommandManager.RequerySuggested += value; }
            remove { CommandManager.RequerySuggested -= value; }
        }
    }

    class RelayCommand<T> : ICommand 
    {
        private readonly Action<T> _execute;
        private readonly Func<T,bool> _canExecute;

        public RelayCommand(Action<T> execute, Func<T,bool> canExecute = null)
        {
            _execute = execute;
            _canExecute = canExecute ?? (t => true);
        }

        public bool CanExecute(object parameter)
        {
            return (parameter is T) && _canExecute((T) parameter);
        }

        public void Execute(object parameter)
        {
            if (parameter is T)
            {
                _execute((T)parameter);
            }
        }

        public event EventHandler CanExecuteChanged
        {
            add { CommandManager.RequerySuggested += value; }
            remove { CommandManager.RequerySuggested -= value; }
        }
    }
}
