﻿using Curse.FriendsService.Tester.Events;
using Curse.FriendsService.Tester.UI.Messaging;
using Curse.SocketInterface;

namespace Curse.FriendsService.Tester.UI.ViewModels
{
    class ClientViewModel : BaseViewModel
    {
        private static int _clientNumber = 1;

        internal readonly TestClient Client;
        private readonly IMessenger _messenger;

        public ClientViewModel(ServiceConnectionInfo connectionInfo)
        {
            Client = new TestClient(connectionInfo, true);

            _messenger = GlobalMessenger.Instance.GetScopedMessenger();
            Title = "Client " + _clientNumber++;
            CurrentView = new DisconnectedClientViewModel(Client, _messenger);

            Client.Events.Register<NotificationsDisconnected>(NotificationClient_NotificationClientDisconnected);
            _messenger.Register<LoginMessage>(ReceiveLoginMessage);
            _messenger.Register<LogoutMessage>(ReceiveLogoutMessage);
        }

        private object _currentView;
        public object CurrentView
        {
            get { return _currentView; }
            set
            {
                if (_currentView != value)
                {
                    _currentView = value;
                    OnPropertyChanged();
                }
            }
        }

        private string _title;
        public string Title
        {
            get { return _title; }
            set
            {
                if (_title != value)
                {
                    _title = value;
                    OnPropertyChanged();
                }
            }
        }

        private void ReceiveLogoutMessage(LogoutMessage obj)
        {
            CurrentView = new DisconnectedClientViewModel(Client, _messenger);
        }

        private void ReceiveLoginMessage(LoginMessage obj)
        {
            var friendsList = new FriendsList(Client);
            CurrentView = new ConnectedClientViewModel(Client, _messenger, friendsList,
                new GroupsList(Client, _messenger, friendsList, obj.CurrentUser));
        }

        void NotificationClient_NotificationClientDisconnected(NotificationsDisconnected e)
        {
            CurrentView = new DisconnectedClientViewModel(Client, _messenger)
            {
                ErrorMessage = e.DisconnectReason==SocketDisconnectReason.UserInitiated?null:"Service forcefully ended connection."
            };
        }

    }
}
