﻿using System.Collections.ObjectModel;
using System.Linq;
using System.Windows.Input;
using Curse.FriendsService.Tester.UI.Messaging;
using Curse.FriendsService.Tester.UI.Options;

namespace Curse.FriendsService.Tester.UI.ViewModels
{
    class CommandsViewModel : BaseViewModel
    {
        private readonly TestClient _client;

        public ObservableCollection<BaseCommandOption> CommandOptions { get; private set; }

        private BaseCommandOption _selectedCommand;

        public BaseCommandOption SelectedCommand
        {
            get
            {
                return _selectedCommand;
            }
            set
            {
                if (_selectedCommand != value)
                {
                    _selectedCommand = value;
                    OnPropertyChanged();
                }
            }
        }

        public ICommand ExecuteCommand { get; private set; }

        public CommandsViewModel(TestClient client, IMessenger messenger, FriendsList friendsList, GroupsList groupsList)
        {
            _client = client;
            CommandOptions = new ObservableCollection<BaseCommandOption>
            {
                new NewGroupCommand(messenger, friendsList,groupsList),
                new LeaveGroupCommand(messenger,groupsList),
                new DeleteGroupCommand(messenger, groupsList),
                new RemoveGroupMemberCommand(messenger, groupsList),
                new AddGroupMemberCommand(messenger,groupsList,friendsList),
                new ChangeGroupMemberRoleCommand(messenger, groupsList),
                new CreateGroupInviteCommand(messenger, groupsList),
                new ClaimGroupInviteCommand(messenger),
                new DeleteGroupInviteCommand(messenger,groupsList),

                new MessageGroupCommand(messenger, groupsList, friendsList),
                new RenameGroupCommand(messenger, groupsList),
                new ChangeGroupNotificationPreferenceCommand(messenger,groupsList),
                new ToggleFavoriteGroupCommand(messenger, groupsList),
                new SyncOfflineMessagesCommand(messenger, groupsList, friendsList),

                new ChangeStatusCommand(messenger),
                new ChangeGameStatusCommand(messenger),
                new MessageFriendCommand(messenger, friendsList),
                new ToggleFavoriteFriendCommand(messenger, friendsList),
                new AddFriendCommand(messenger),
                new RemoveFriendCommand(messenger, friendsList),
                new UnblockFriendCommand(messenger),

                new VoiceCallCommand(messenger, groupsList, friendsList),
                new FindFriendCommand(messenger),
            };

            SelectedCommand = CommandOptions.First();
            ExecuteCommand = new RelayCommand(Execute);
        }

        private void Execute()
        {
            SelectedCommand.Execute(_client);
        }
    }
}
