﻿using Curse.FriendsService.Tester.UI.Messaging;

namespace Curse.FriendsService.Tester.UI.ViewModels
{
    class ConnectedClientViewModel : BaseViewModel
    {
        public ConnectedClientViewModel(TestClient client, IMessenger messenger, FriendsList friendsList, GroupsList groupsList)
        {
            var currentUser = new CurrentUserViewModel(client);

            CurrentUser = new StatusViewModel(client, messenger, currentUser, friendsList, groupsList);
            Commands = new CommandsViewModel(client, messenger, friendsList, groupsList);
            Notifications = new NotificationsViewModel(client, currentUser, friendsList, groupsList, messenger);
        }

        public StatusViewModel CurrentUser { get; private set; }

        public CommandsViewModel Commands { get; private set; }

        public NotificationsViewModel Notifications { get; private set; }
    }
}
