﻿using System.Windows.Input;
using Curse.Friends.Client.FriendsService;
using Curse.FriendsService.Tester.Actions;
using Curse.FriendsService.Tester.People;

namespace Curse.FriendsService.Tester.UI.ViewModels
{
    class CurrentUserViewModel : UserViewModel
    {
        private readonly TestClient _client;
        public CurrentUser CurrentUser { get; private set; }

        public CurrentUserViewModel(TestClient client) : base(client, client.CurrentUser)
        {
            _client = client;
            CurrentUser = client.CurrentUser;

            DiscardCommand = new RelayCommand(Discard);
            SubmitCommand = new RelayCommand(Submit);
        }

        public ICommand DiscardCommand { get; private set; }
        public ICommand SubmitCommand { get; private set; }

        private string _newAvatarUrl;

        public string NewAvatarUrl
        {
            get { return _newAvatarUrl; }
            set
            {
                if (_newAvatarUrl != value)
                {
                    _newAvatarUrl = value;
                    OnPropertyChanged();
                }
            }
        }

        private string _newAboutMe;
        public string NewAboutMe
        {
            get { return _newAboutMe; }
            set
            {
                if (_newAboutMe != value)
                {
                    _newAboutMe = value;
                    OnPropertyChanged();
                }
            }
        }

        private void Discard()
        {
            NewAvatarUrl = AvatarUrl;
            NewAboutMe = AboutMe;
        }

        private void Submit()
        {
            string error;
            if (_client.Execute(new ChangeProfile {AvatarUrl = NewAvatarUrl, AboutMe = NewAboutMe}, out error))
            {
                AvatarUrl = NewAvatarUrl;
                AboutMe = NewAboutMe;
            }
        }

        protected override void UpdateProfileFields(User user)
        {
            AvatarUrl = user.AvatarUrl;
            NewAvatarUrl = AvatarUrl;
            AboutMe = user.AboutMe;
            NewAboutMe = AboutMe;
        }
    }
}
