﻿using System.Net;
using System.Security;
using System.Windows.Input;
using Curse.FriendsService.Tester.Actions;
using Curse.FriendsService.Tester.UI.Messaging;

namespace Curse.FriendsService.Tester.UI.ViewModels
{
    class DisconnectedClientViewModel : BaseViewModel
    {
        private readonly TestClient _client;
        private readonly IMessenger _messenger;

        private string _username;
        public string Username
        {
            get { return _username; }
            set
            {
                if (_username != value)
                {
                    _username = value;
                    OnPropertyChanged();
                }
            }
        }

        public SecureString SecurePassword { private get; set; }

        public ICommand LoginCommand { get; private set; }

        private string _errorMessage;
        public string ErrorMessage
        {
            get { return _errorMessage; }
            internal set
            {
                if (_errorMessage != value)
                {
                    _errorMessage = value;
                    OnPropertyChanged();
                }
            }
        }

        public DisconnectedClientViewModel(TestClient client, IMessenger messenger)
        {
            _client = client;
            _messenger = messenger;
            LoginCommand = new RelayCommand(Login);
        }

        public void Login()
        {
            string errorMessage;


            if(_client.Login(new LoginInfo(new NetworkCredential(_username,SecurePassword)), out errorMessage))
            {
                _messenger.Raise(new LoginMessage {CurrentUser = _client.CurrentUser});
            }
            else
            {
                ErrorMessage = "Failed to log in: " + errorMessage;
            }
        }
    }
}
