﻿using System.Collections.ObjectModel;
using System.Linq;
using Curse.FriendsService.Tester.People;

namespace Curse.FriendsService.Tester.UI.ViewModels
{
    class FriendsList : BaseViewModel
    {
        private readonly TestClient _client;

        public ObservableCollection<FriendViewModel> Friends { get; private set; }

        public FriendsList(TestClient client)
        {
            _client = client;

            Friends = new DispatchedObservableCollection<FriendViewModel>();

            foreach (var friend in client.FriendCache.Friends)
            {
                AddFriend(friend);
            }

            client.FriendCache.Added += FriendAdded;
            client.FriendCache.Removed += FriendRemoved;
        }

        void FriendAdded(object sender, FriendEventArgs args)
        {
            AddFriend(args.AffectedFriend);
        }

        void FriendRemoved(object sender, FriendEventArgs args)
        {
            Friends.Remove(Friends.FirstOrDefault(f => f.UserID == args.AffectedFriend.UserID));
        }

        private void AddFriend(Friend friend)
        {
            if (Friends.All(f => f.UserID != friend.UserID))
            {
                Friends.Add(new FriendViewModel(_client, friend));
            }
        }
    }
}
