﻿using System;
using System.Collections.ObjectModel;
using System.Linq;
using System.Windows.Threading;
using Curse.FriendsService.Tester.Groups;
using Curse.FriendsService.Tester.UI.Messaging;

namespace Curse.FriendsService.Tester.UI.ViewModels
{
    class GroupsList
    {
        private readonly TestClient _client;
        private readonly IMessenger _messenger;
        private readonly FriendsList _friendsList;
        private readonly Dispatcher _dispatcher;
        private readonly User _user;

        public ObservableCollection<GroupViewModel> Groups { get; private set; }

        public GroupsList(TestClient client, IMessenger messenger, FriendsList friendsList, User currentUser)
        {
            _dispatcher = Dispatcher.CurrentDispatcher;
            _client = client;
            _messenger = messenger;
            _friendsList = friendsList;
            _user = currentUser;

            Groups = new DispatchedObservableCollection<GroupViewModel>();

            foreach (var group in client.GroupCache.Groups)
            {
                AddGroup(group);
            }

            client.GroupCache.Added += GroupAdded;
            client.GroupCache.Removed += GroupRemoved;
        }

        void GroupAdded(object sender, GroupEventArgs e)
        {
            Dispatch(() => AddGroup(e.AffectedGroup));
        }

        void GroupRemoved(object sender, GroupEventArgs e)
        {
            Dispatch(() => RemoveGroup(e.AffectedGroup));
        }

        private void Dispatch(Action action)
        {
            if (_dispatcher.CheckAccess())
            {
                action();
            }
            else
            {
                _dispatcher.Invoke(action);
            }
        }

        private void AddGroup(GroupCache group)
        {
            if (Groups.All(g => g.GroupID != group.RootGroup.GroupID))
            {
                Groups.Add(new GroupViewModel(group, _client, _messenger, _friendsList));
            }
        }

        private void RemoveGroup(GroupCache group)
        {
            Groups.Remove(Groups.FirstOrDefault(g => g.GroupID == group.RootGroup.GroupID));
        }
    }
}
