﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Windows.Input;
using Curse.FriendsService.Tester.UI.Messaging;

namespace Curse.FriendsService.Tester.UI.ViewModels
{
    class MainWindowViewModel : BaseViewModel
    {
        private static readonly List<string> _serviceUrls = Enum.GetValues(typeof (ServiceEnvironment)).Cast<ServiceEnvironment>().OrderBy(e => (int) e).Select(e => e.GetDescription()).ToList();

        private ServiceConnectionInfo _connectionInfo;

        public MainWindowViewModel()
        {
            AddClientCommand = new RelayCommand(AddClient);
            SelectServerCommand = new RelayCommand<string>(SelectServer);
            Clients = new DispatchedObservableCollection<ClientViewModel>();
        }

        private bool _isServerSelected;
        public bool IsServerSelected
        {
            get
            {
                return _isServerSelected;
            }
            private set
            {
                if (_isServerSelected != value)
                {
                    _isServerSelected = value;
                    OnPropertyChanged();
                }
            }
        }

        public List<string> ServiceUrls
        {
            get { return _serviceUrls; }
        }
        public ICommand SelectServerCommand { get; private set; }

        private void SelectServer(string server)
        {
            _connectionInfo = new ServiceConnectionInfo(server.GetValueFromDescription<ServiceEnvironment>());
            AddClient();
            IsServerSelected = true;
        }

        public ICommand AddClientCommand { get; private set; }
        public ObservableCollection<ClientViewModel> Clients { get; private set; }

        private void AddClient()
        {
            Clients.Add(new ClientViewModel(_connectionInfo));
        }
    }
}
