﻿using Curse.Friends.Client.FriendsService;
using Curse.Friends.Enums;

namespace Curse.FriendsService.Tester.UI.ViewModels
{
    class UserViewModel : BaseViewModel
    {
        private readonly User _user;
        protected readonly TestClient Client;

        public UserViewModel(TestClient client, User user)
        {
            Client = client;
            _user = user;
        }

        public int UserID { get { return _user.UserID; } }

        public string Username
        {
            get { return _user.Username; }
        }

        public UserConnectionStatus ConnectionStatus
        {
            get { return _user.ConnectionStatus; }
            set
            {
                if (ConnectionStatus != value)
                {
                    _user.ConnectionStatus = value;
                    OnPropertyChanged();
                }
            }
        }

        public string StatusMessage
        {
            get { return _user.StatusMessage;}
            set
            {
                if (StatusMessage != value)
                {
                    _user.StatusMessage = value;
                    OnPropertyChanged();
                }
            }
        }

        public int GameID
        {
            get { return _user.GameID; }
            set
            {
                if (GameID != value)
                {
                    _user.GameID = value;
                    OnPropertyChanged();
                }
            }
        }

        public string GameStatusMessage
        {
            get { return _user.GameStatusMessage; }
            set
            {
                if (GameStatusMessage != value)
                {
                    _user.GameStatusMessage = value;
                    OnPropertyChanged();
                }
            }
        }

        public string AvatarUrl
        {
            get { return _user.AvatarUrl; }
            set
            {
                if (AvatarUrl != value)
                {
                    _user.AvatarUrl = value;
                    OnPropertyChanged();
                }
            }
        }

        public string AboutMe
        {
            get { return _user.AboutMe; }
            set
            {
                if (AboutMe != value)
                {
                    _user.AboutMe = value;
                    OnPropertyChanged();
                }
            }
        }

        public string Name
        {
            get { return _user.Name; }
            set
            {
                if (Name != value)
                {
                    _user.Name = value;
                    OnPropertyChanged();
                }
            }
        }

        public void RefreshProfile()
        {
            _user.RefreshProfile();
            UpdateProfileFields(_user);
            OnPropertyChanged(string.Empty);
        }

        protected virtual void UpdateProfileFields(User user)
        {
            
        }
    }
}
