﻿using System.ComponentModel;
using System.Windows;
using Curse.FriendsService.Tester.Actions;
using Curse.FriendsService.Tester.UI.Messaging;
using Curse.FriendsService.Tester.UI.ViewModels;

namespace Curse.FriendsService.Tester.UI.Views
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();

            GlobalMessenger.Instance.Register<MessageBoxMessage>(ReceiveMessageBoxMessage);
        }

        private void QuitMenuItem_OnClick(object sender, RoutedEventArgs e)
        {
            Close();
        }

        private void ReceiveMessageBoxMessage(MessageBoxMessage message)
        {
            Dispatcher.Invoke(() =>
            {
                MessageBox.Show(message.Message, message.Title, MessageBoxButton.OK);
            });
        }

        private void MainWindow_OnClosing(object sender, CancelEventArgs e)
        {
            foreach(var client in ((MainWindowViewModel)DataContext).Clients)
            {
                string throwaway;
                client.Client.Logout(out throwaway);
            }
        }
    }
}
