﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using Curse.FriendsService.Tester.UI.ViewModels;

namespace Curse.FriendsService.Tester.UI.Views
{
    /// <summary>
    /// Interaction logic for CurrentUserView.xaml
    /// </summary>
    public partial class StatusView : UserControl
    {
        public StatusView()
        {
            InitializeComponent();
        }

        private void GroupDetailsButton_OnClick(object sender, RoutedEventArgs e)
        {
            var group = (GroupViewModel) ((Button) sender).DataContext;
            group.RefreshGroupDetails();
            new GroupDetailsWindow()
            {
                DataContext = group,
                Owner = Window.GetWindow(this),
            }.ShowDialog();
        }

        private void FriendProfileButton_OnClick(object sender, RoutedEventArgs e)
        {
            var friend = (FriendViewModel) ((Button) sender).DataContext;
            friend.RefreshProfile();
            new FriendProfileWindow()
            {
                DataContext = friend,
                Owner = Window.GetWindow(this)
            }.ShowDialog();
        }

        private void MyProfileButton_OnClick(object sender, RoutedEventArgs e)
        {
            var currentUser = (CurrentUserViewModel) ((Button) sender).DataContext;
            currentUser.RefreshProfile();
            new MyProfileWindow()
            {
                DataContext = currentUser,
                Owner = Window.GetWindow(this)
            }.ShowDialog();
        }
    }
}
