﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Curse.Friends.Client.FriendsService;

namespace Curse.FriendsService.Tester.Actions
{
    public class AcceptFriendCall : BaseAction
    {
        private readonly int _friendID;
        private readonly string _inviteCode;
        private readonly long _accessToken;

        public Version ClientVersion { get; set; }

        public AcceptFriendCall(int friendID, string inviteCode, long accessToken)
        {
            _friendID = friendID;
            _inviteCode = inviteCode;
            _accessToken = accessToken;

            ClientVersion = new Version(6, 2, 0, 0);
        }

        protected internal override bool Execute(TestClient client, out string message)
        {
            try
            {
                var resp = client.WebClient.Call("Accept", svc => svc.RespondToCall(new RespondToCallRequest {Accepted = true, FriendID = _friendID, InviteUrl = _inviteCode}));

                if (resp.Status != RespondToCallStatus.Successful)
                {
                    message = "Failed to accept voice call. Service responded with " + resp.Status;
                    return false;
                }

                client.VoiceRuntimeClient.JoinFriendCall(client.CurrentUser, _inviteCode, _friendID, _accessToken);
                message = null;
                return true;
            }
            catch (Exception ex)
            {
                message = "Unexpected exception. " + ex.Message;
                return false;
            }
        }    }
}
